*
* CLOCK
* PERIODIC TIMER FUNCTIONS FOR MARINA IP
* 22 MAR 15 - D. FINNIGAN
*
* DESIGNED FOR USE WITH THE M5832 CLOCK CHIP.
*
* TIMERS
ARPTIMER DFB 0
DHCPTIMER DFB 0
ACDTIMER DFB 0
DNSTIMER DFB 0
IPFTIMER DFB 0 ; IP FRAGMENTATION REASSEMBLY
TCPTIMER DFB 0 ; TCP SEGMENT RETRANSMIT
*
* CLOCK IRQ
* THE 1-SECOND INTERRUPT REQUEST HANDLER
* USES ONLY THE A REGISTER
CLOCKIRQ
 LDA $45
 PHA
 LDA ARPTIMER ; GET CURRENT TIMER VALUE
 BEQ :N ; IF 0, TIMER IS NOT IN USE
 DEC ARPTIMER
 BNE :N ; IF NOT 0, THEN MOVE ON
* TIMER REACHED ZERO, SO SET THE FLAG
 LDA TIMEFLAG
 ORA #%11000000 ; SET THE ANY-FLAG AND ARP FLAG
 STA TIMEFLAG
:N LDA DHCPTIMER
 BEQ :N2
 DEC DHCPTIMER
 BNE :N2
 LDA TIMEFLAG
 ORA #%10100000 ; SET THE ANY-FLAG AND THE DHCP FLAG
 STA TIMEFLAG
:N2 LDA ACDTIMER
 BEQ :N3
 DEC ACDTIMER
 BNE :N3
 LDA TIMEFLAG
 ORA #%10010000
 STA TIMEFLAG
:N3 LDA DNSTIMER
 BEQ :N4
 DEC DNSTIMER
 BNE :N4
 LDA TIMEFLAG
 ORA #%10001000
 STA TIMEFLAG
:N4 LDA IPFTIMER
 BEQ :N5
 DEC IPFTIMER
 BNE :N5
 LDA TIMEFLAG
 ORA #%10000100
 STA TIMEFLAG
:N5 LDA TCPTIMER
 BEQ :N6
 DEC TCPTIMER
 BNE :N6
 LDA TIMEFLAG
 ORA #%10000010
 STA TIMEFLAG
:N6   ; RESERVED FOR FUTURE USE
:DONE
 PLA
 RTI
*
* CLOCK INIT
* SETUP CLOCK AND IRQ
CLOCKINIT
 LDA #0 ; CLEAR ALL TIMERS AND FLAGS
 STA TIMEFLAG
 STA ARPTIMER
 STA DHCPTIMER
 STA ACDTIMER
 STA DNSTIMER
 STA IPFTIMER
 STA TCPTIMER
 RTS
